IF OBJECT_ID('GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS') IS NULL
BEGIN
	CREATE TABLE GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS(
		CD_CTR BIGINT NOT NULL IDENTITY,
		CD_CTR_RETORNO BIGINT NOT NULL,
		CD_EMP INT NOT NULL,
		CD_PROD INT NOT NULL,
		CD_PROD_RETORNADO VARCHAR(50),
		NR_NCM VARCHAR(50),
		NR_CEST VARCHAR(20),
		LISTA_PROD VARCHAR(2),
		TIPO_PROD VARCHAR(2),
		CTR_PMC VARCHAR(2),
		IMPOSTO_IMP MONEY);
END

GO

IF OBJECT_ID('PK_GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS') IS NULL 
BEGIN
	ALTER TABLE GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS ADD CONSTRAINT PK_GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS PRIMARY KEY (CD_CTR);
END

GO

IF NOT EXISTS (SELECT * FROM SYS.indexes WHERE NAME = 'UK_GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_CD_CTR_RETORNO_CD_EMP_CD_PROD')
BEGIN
	CREATE UNIQUE INDEX UK_GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_CD_CTR_RETORNO_CD_EMP_CD_PROD ON GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS(CD_CTR_RETORNO, CD_EMP, CD_PROD);
END

GO

IF OBJECT_ID('FK_GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_GT_RETORNO_CABECALHO') IS NULL 
BEGIN
	ALTER TABLE GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS ADD CONSTRAINT FK_GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_GT_RETORNO_CABECALHO FOREIGN KEY(CD_CTR_RETORNO) REFERENCES GT_RETORNO_CABECALHO(CD_CTR);
END

GO

IF OBJECT_ID('FK_GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_EST_PROD') IS NULL 
BEGIN
	ALTER TABLE GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS ADD CONSTRAINT FK_GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_EST_PROD FOREIGN KEY (CD_EMP, CD_PROD) REFERENCES EST_PROD (CD_EMP, CD_PROD);
END

GO
